/** @file   corpse.h
 * @brief   Declaration of Corpse - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_CORPSE_H
#define H_WWW_CORPSE_H

#include "gameobject.h"

namespace WeWantWar {


/** @class  Corpse
 * @brief   Dead people lying on the floor are instances of this class.
 * @author  Tomi Lamminsaari
 *
 * What kind of graphics the corpses have is defined randomly in
 * class constructor.
 *
 * @note
 * In future this class might become obsole. There is @c Civilian - class
 * that can handle dead civilians so these corpses could be replaced by
 * killed Civilians.
 */
class Corpse : public GameObject
{
public:

  /** Possible corpse categories. These are used in constructor call.
   * NOT IMPLEMENTED YET !
   */
  enum ID {
    /** The corpse can be either Alien or human corpse. */
    ID_RANDOM,
    /** The corpse should represent  Human */
    ID_HUMAN,
    /** The corpse should represent an Alien */
    ID_ALIEN
  };
  

  /** Constructor. Chooses randomly either human or alien corpse.
   */
  Corpse();
  
  /** Constructs desired corpse type.
   * @param     corpseID          The type of this corpse.
   */
  Corpse( ID corpseID );
  
  /** Destructor.
   */
  virtual ~Corpse();
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates this corpse.
   */
  virtual void update();
  
  /** Draws this corpse.
   * @param     pQueue            Pointer to redraw queue
   */
  virtual void redraw( RedrawQueue* pQueue );
  
  /** Implemented.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** Implemented.
   */
  virtual void kill();
  
  /** We got hit by a bullet
   * @param     pB                Pointer to bullet that hit us.
   * @return    Always 'false' since corpses cannot be shot.
   */
  virtual bool hitByBullet( Bullet* pB );
  
  
  
  ///
  /// Getter-methods
  /// ==============
  
  /** Is this object loading.
   * @return    Always <code>false</code> since dead people don't have
   *            weapons.
   */
  virtual bool reloading() const;
  
  /** Returns the ID of the corpse graphics that is assigned to this
   * Corpse.
   * @return    Graphics id that can be used as an index to graphics
   *            vector GfxPool::corpse_images
   */
  int getGfxID() const;
  
  /** Returns the type of this object.
   * @return    ObjectID::TYPE_CORPSE
   */
  virtual ObjectID::Type objectType() const;
  

protected:

  ///
  /// Members
  /// =======
  
  /** Graphics id. */
  int m_corpseGfxID;
  
};

};  // end of namespace

#endif // CORPSE_H


/**
 * Version history
 * ===============
 * $Log: corpse.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:53+02  lamminsa
 * Initial revision
 *
 */
  
